function [time, rain_rate, total_drops, drop_diameter, num_drops, mean_dropdiameter, rain_amount, median_dropdiameter, drops_time, fall_speed] = VideoDisdromeder_Import()
%% Video Disdrometer Regular
cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\Video Disdrometer');

currdir = dir;
time = [];
rain_rate = [];
total_drops = [];
drop_diameter = [];
num_drops = [];
rain_amount = [];
median_dropdiameter = [];

for i = 1:length(currdir)
	
	cdfcheck = strfind(currdir(i).name,'.cdf');
	if isempty(cdfcheck)
		continue
	end
	currfile = currdir(i).name;
	startdate = [str2num(currfile(14:17)), str2num(currfile(18:19)), str2num(currfile(20:21)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	currrainrate = ncread(currfile,'rain_rate');
	rain_rate = [rain_rate; currrainrate];
	
	currtotaldrops = ncread(currfile,'total_drops');
	total_drops = [total_drops ; currtotaldrops];
	
	drop_diameter = ncread(currfile,'drop_diameter');
	drop_diameter = double(drop_diameter');
	%currdropdiameter = currdropdiameter';
	%dropdiameter = [dropdiameter ; currdropdiameter];
	
	currmedian_dropdiameter = ncread(currfile,'median_volume_diameter');
	median_dropdiameter = [median_dropdiameter ; currmedian_dropdiameter];
	
	currnumdrops = ncread(currfile,'num_drops');
	currnumdrops = currnumdrops';
	num_drops = [num_drops ; currnumdrops];
	
	currrainamount = ncread(currfile,'rain_amount');
	rain_amount = [rain_amount ; currrainrate];
	
end
rain_amount = double(rain_amount);
rain_rate = double(rain_rate);
total_drops = double(total_drops);
num_drops = double(num_drops);


for j = 1:size(num_drops,1)
	prob_drops(j,:) = num_drops(j,:) ./ sum(num_drops(j,:));
	mean_dropdiameter(j,:) = sum(prob_drops(j,:) .* drop_diameter);
	if isnan(mean_dropdiameter(j,:))
		mean_dropdiameter(j,:) = 0;
	end
end

%% Video Disdrometer Drops

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\Video Disdrometer Drops');
currdir = dir;
fall_speed = [];

drops_time = [];

for i = 1:length(currdir)
	cdfcheck = strfind(currdir(i).name,'.cdf');
	if isempty(cdfcheck)
		continue
	end
	currfile = currdir(i).name;
	
	startdate = [str2num(currfile(19:22)), str2num(currfile(23:24)), str2num(currfile(25:26)), 0, 0, 0];
	sec_time2 = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time2),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time2;
	currtimemat = datetime(currtimemat);
	drops_time = [drops_time ; currtimemat];
	
	
	currfallspeed = ncread(currfile,'fall_speed');
	fall_speed = [fall_speed ; currfallspeed];
	
	
end



end